/***************************************************************************\
 *
 *               (C) copyright Fraunhofer - IIS (2013)
 *                        All Rights Reserved
 *
 *   Project:  Android AAC-ELD Example Source Code
 *
 *   By using this Example Source Code, you agree to the "Terms & Conditions
 *   for Use of Fraunhofer Example Source Code", which is provided as a
 *   separate document together with this file. The "Terms & Conditions for
 *   Use of Fraunhofer Example Source Code" must be part of any redistribution
 *   of the Example Source Code or parts thereof, or modifications of the
 *   Example Source Code.
 *
\***************************************************************************/

#ifndef __AACELD_DECODER_H__
#define __AACELD_DECODER_H__

#include <vector>

// Decoder implementation
class AacEldDecoder {
public:
  // Initialization requires a valid
  // JavaVM handle in order to access
  // the Android MediaCodec APIs
  AacEldDecoder(void *jvmHandle);
  ~AacEldDecoder();

  // Configure the decoder using an audio specific config (ASC)
  bool configure(std::vector<unsigned char>& asc);
  // Decode an access unit to a PCM audio frame
  bool decode(std::vector<unsigned char>& inAU, std::vector<unsigned char>& outSamples);
  // Close the decoder and cleanup
  void close();

private:
  // Private implementation
  // in order to hide all
  // the JNI stuff from
  // the user of the class
  class AacEldDecImpl;
  AacEldDecImpl *impl_;
};

#endif /* __AACELD_DECODER_H__ */
