/***************************************************************************\
 *
 *               (C) copyright Fraunhofer - IIS (2013)
 *                        All Rights Reserved
 *
 *   Project:  Android AAC-ELD Example Source Code
 *
 *   By using this Example Source Code, you agree to the "Terms & Conditions
 *   for Use of Fraunhofer Example Source Code", which is provided as a
 *   separate document together with this file. The "Terms & Conditions for
 *   Use of Fraunhofer Example Source Code" must be part of any redistribution
 *   of the Example Source Code or parts thereof, or modifications of the
 *   Example Source Code.
 *
\***************************************************************************/

#ifndef __AACELD_ENCODER_H__
#define __AACELD_ENCODER_H__

#include <vector>

// Encoder implementation
class AacEldEncoder {
public:
  // Initialization requires a valid
  // JavaVM handle in order to access
  // the Android MediaCodec APIs
  AacEldEncoder(void *jvmHandle);
  ~AacEldEncoder();

  // Configure the encoder with samplerate, number of channels and encoding bitrate
  // Returns a valid audio specific config (ASC) in the asc parameter on success
  bool configure(unsigned int sampleRate, unsigned int nChannels, unsigned int bitrate, std::vector<unsigned char>& asc);
  // Encode input samples, yield an access unit (AU)
  bool encode(std::vector<unsigned char>& inSamples, std::vector<unsigned char>& outAU);
  // Close the encoder and cleanup
  void close();

private:
  // Private implementation
  // in order to hide all
  // the JNI stuff from
  // the user of the class
  class AacEldEncImpl;
  AacEldEncImpl *impl_;
};

#endif /* __AACELD_ENCODER_H__ */
