/***************************************************************************\
 *
 *               (C) copyright Fraunhofer - IIS (2013)
 *                        All Rights Reserved
 *
 *   Project:  Android AAC-ELD Example Source Code
 *
 *   By using this Example Source Code, you agree to the "Terms & Conditions
 *   for Use of Fraunhofer Example Source Code", which is provided as a
 *   separate document together with this file. The "Terms & Conditions for
 *   Use of Fraunhofer Example Source Code" must be part of any redistribution
 *   of the Example Source Code or parts thereof, or modifications of the
 *   Example Source Code.
 *
\***************************************************************************/

#ifndef __AUDIOPROCESSOR_H__
#define __AUDIOPROCESSOR_H__

#include <vector>

#include "AacEldEncoder.h"
#include "AacEldDecoder.h"

// Exemplary implementation of native
// audio processing code using the
// Android internal AAC-ELD encoders and
// decoders through JNI
class AudioProcessor {
public:
  // No matter what your specific library needs for initialization, it absolutely
  // needs a pointer to a JavaVM in order to
  // access the Java MediaCodec instances later within the AacEldEncoder and AacEldDecoder classes...
  AudioProcessor(int sampleRate, int nChannels, int bitrate, int framesize, int noOfBytesPerSample, void *jvmHandle);
  ~AudioProcessor();

  // Here the audio encoding and decoding takes place
  void process(std::vector<unsigned char>& inSamples, std::vector<unsigned char>& outSamples);

private:
  // Encoder and decoder instances
  // which use JNI in order to access
  // the Android MediaCodec APIs
  AacEldEncoder m_encoder;
  AacEldDecoder m_decoder;

  unsigned int sampleRate;
  unsigned int nChannels;
  unsigned int bitrate;
  unsigned int frameSize;
  unsigned int noOfBytesPerSample;
};

#endif /* __AUDIOPROCESSOR_H__ */
