/***************************************************************************\
 *
 *               (C) copyright Fraunhofer - IIS (2013)
 *                        All Rights Reserved
 *
 *   Project:  Android AAC-ELD Example Source Code
 *
 *   By using this Example Source Code, you agree to the "Terms & Conditions
 *   for Use of Fraunhofer Example Source Code", which is provided as a
 *   separate document together with this file. The "Terms & Conditions for
 *   Use of Fraunhofer Example Source Code" must be part of any redistribution
 *   of the Example Source Code or parts thereof, or modifications of the
 *   Example Source Code.
 *
\***************************************************************************/

#ifndef __JNI_ENV_GUARD_H__
#define __JNI_ENV_GUARD_H__

#include <jni.h>

class JniEnvGuard {
public:
    explicit JniEnvGuard(JavaVM* vm, jint version = JNI_VERSION_1_6);
    ~JniEnvGuard();

    JNIEnv* operator->();
    JNIEnv const* operator->() const;

private:
  JavaVM *vm_;
  JNIEnv *env_;
  bool   threadAttached_;
};

#endif /* __JNI_ENV_GUARD_H__ */
