/***************************************************************************\
 *
 *               (C) copyright Fraunhofer - IIS (2013)
 *                        All Rights Reserved
 *
 *   Project:  Android AAC-ELD Example Source Code
 *
 *   By using this Example Source Code, you agree to the "Terms & Conditions 
 *   for Use of Fraunhofer Example Source Code", which is provided as a 
 *   separate document together with this file. The "Terms & Conditions for 
 *   Use of Fraunhofer Example Source Code" must be part of any redistribution
 *   of the Example Source Code or parts thereof, or modifications of the 
 *   Example Source Code.
 *
\***************************************************************************/

package de.fraunhofer.iis.android_aaceld;

// Java class implementing native methods 
// that will access the native AudioProcessor
// class (which just represents any other
// audio processing library)
public class NativeAudioProcessor {
  
  // Load required native libraries when
  // the first instance of this class is
  // created
  static {
    System.loadLibrary("gnustl_shared");
    System.loadLibrary("android_aaceld");
  }

  // Private variables storing pointers 
  // to native object instances
  private long AudioProcessorHandle;
  private long InputAudioFrameHandle;
  private long OutputAudioFrameHandle;
  
  // The native methods that take care of interacting with the native 
  // audio processing part of the demo project
  native boolean init(int sampleRate, int nChannels, int bitrate, int framesize, int noOfBytesPerSample);
  native boolean process(byte[] inSamples, byte[] outSamples);
  native boolean close();
}
