import numpy as np
import matplotlib.colors
import matplotlib.cm as colormaps
import matplotlib.pyplot as plt


if __name__ == '__main__':
    volumeArchive = np.load(".\\exampleVolume.npz")
    dataVolume = volumeArchive["dataVolume"]
    targetVolume = volumeArchive["targetVolume"]

    fig, axs = plt.subplots(1, 2)
    axs[0].imshow(dataVolume[64, :, :], interpolation="none", cmap="gray")
    axs[0].set_title("data volume")
    axs[0].axis(False)

    segment_num = 13  # count of segments (+ background) present in the example volume
    cmap = matplotlib.colors.ListedColormap([colormaps.nipy_spectral(x) for x in np.linspace(0, 1, segment_num)])
    axs[1].imshow(targetVolume[64, :, :], interpolation="none", cmap=cmap)
    axs[1].set_title("target volume")
    axs[1].axis(False)

    plt.show()
