 /*************************************************************************************
	Intel Corp.

    Project Name:  60 GHz Channel Model
    File Name:     ant_gain.c
    Authors:       A. Lomayev, R. Maslennikov
    Version:       5.0
    History:       May 2010 created

  *************************************************************************************
    Description:

    function returns amplitudes weighted by antenna gains for target antenna space
	position
    
  *************************************************************************************/

double ant_gain(INT32S ant_type, FP64 hpbw, INT32S size, FP64 *am_r, FP64 *am_i, FP64 *az, FP64 *el, FP64 az_rot, FP64 el_rot, FP64 *amg_r, FP64 *amg_i, FP64 power)
{
	/* pointers */
	INT32S i;
	/* azimuth rotation angle + 90 degree */
	FP64 az_rot90;
	/* azimuth and elevation angles in rotated coordinates */
	FP64 *azr, *elr;

	/* select antenna type */
	switch (ant_type)
	{
	case 0: /* isotropic radiator */
		
		/* initialize power variable */
		power = 0;
		for (i=0; i<size; i++)
		{
			amg_r[i] = am_r[i];
			amg_i[i] = am_i[i];
			power = power + pow(amg_r[i],2) + pow(amg_i[i],2);
		}		
		break;
	case 1: /* steerable directional antenna */
		
		/* allocate memory for azr */
		azr = (FP64 *)MEM_CALLOC(size,sizeof(FP64));
		/* allocate memory for elr */
		elr = (FP64 *)MEM_CALLOC(size,sizeof(FP64));

		az_rot90 = (az_rot+90) - 360*floor((az_rot+90)/360);
		/* convert azimuth and elevation angles from basic to rotated coordinates specified by az_rot and el_rot angles */
		basic2rot(size, az, el, az_rot90, el_rot, 0.0, azr, elr);		
		power = steer_antenna(size, am_r, am_i, elr, hpbw, amg_r, amg_i, power);

		/* free azr */
		MEM_FREE(azr);
		/* free elr */
		MEM_FREE(elr);
		break;
	default:
		power = 0;
		break;
	}
	return power;
}
