 /*************************************************************************************
	Intel Corp.
	
    Project Name:  60 GHz Channel Model
    File Name:     basic2rot.c
    Authors:       A. Lomayev, R. Maslennikov
    Version:       5.0
    History:       May 2010 created

  *************************************************************************************
    Description:

    function performs recalculation of azimuth and elevation angles
    determinig in basic coordinates to rotated coordinates,
    univocal rotated system position is set by 3 Euler's rotations
    (by corresponding 3 angles)
    
  *************************************************************************************/

void basic2rot(INT32S size, FP64 *az, FP64 *el, FP64 az_rot, FP64 el_rot, FP64 self_rot, FP64 *azr, FP64 *elr)
{
	/* pointers */
	INT32S i;
	/* cartesian coordinates in basic and rotated systems */
	FP64 x, y, z, xr, yr, zr;
	/* constants utilizing in calculation of coordinates in rotated system */
	FP64 x1, y1, x2, y2, x3, y3, a, b, c, d, f, e, g, h;

	
	for (i=0; i<size; i++)
	{
		/* spherical to cartesian coordinates covertion in basic system */
		x = sin(el[i]*D2R)*cos(az[i]*D2R); /* D2R - degree to radian conversion constant defined in bf.h */
		y = sin(el[i]*D2R)*sin(az[i]*D2R);
		z = cos(el[i]*D2R);

		/* calculation of constants to compose rotation matrix */
		x1 = cos(self_rot*D2R);
		y1 = sin(self_rot*D2R);
		x2 = cos(el_rot*D2R);
		y2 = sin(el_rot*D2R);
		x3 = cos(az_rot*D2R);
		y3 = sin(az_rot*D2R);
		
		a = x1*x3 - x2*y3*y1;
		b = x1*y3 + y1*x2*x3;
		c = y1*y2;
		d = -y1*x3 - x1*x2*y3;
		e = -y1*y3 + x1*x2*x3;
		f = x1*y2;
		g = y2*y3;
		h = -y2*x3;
		
		/* cartesian coordinates in rotated system */
		xr = a*x + b*y + c*z;
		yr = d*x + e*y + f*z;
		zr = g*x + h*y + x2*z;

		/* azimuth and elevation angles in rotated system */
		azr[i] = atan2(yr,xr); /* range [-pi/2:pi/2] */
		elr[i] = acos(zr);

		/* radian to degree convertion */
		azr[i] = azr[i]*R2D; /* R2D - radian to degree conversion constant defined in bf.h */
		azr[i] = (360+azr[i]) - 360*floor((360+azr[i])/360); /* azimuth angle should be [0:360] */
		elr[i] = elr[i]*R2D;
	}
}
