 /*************************************************************************************
	Intel Corp.

    Project Name:  60 GHz Channel Model
    File Name:     bf.h
    Authors:       A. Lomayev, R. Maslennikov
    Version:       5.0
    History:       May 2010 created

  *************************************************************************************
    Description:

    declaration of data types

  *************************************************************************************/
#ifndef _BF
#define _BF

#include  <stdio.h>
#include  <stdlib.h>
#include  <math.h>

/**************************************************************************************/
/*		CONSTANTS											                          */
/**************************************************************************************/

/* degree to radian and vice versa conversion constants */
#define D2R		 0.01745329251994
#define R2D		57.29577951308232
/* pi */
#define PI		3.14159265358979
/* wave vector corresponded to 60GHz frequency */
#define K		2*PI/0.005

/**************************************************************************************/
/*		C/MATLAB MEMORY ALLOCATION FUNCTIONS				                          */
/**************************************************************************************/
#ifdef MATLAB
    #define MEM_CALLOC(a, b) mxCalloc(a, b)
    #define MEM_FREE(a) mxFree(a)
#else
    #define MEM_CALLOC(a, b) calloc(a, b)
    #define MEM_FREE(a) free(a)
#endif

/**************************************************************************************/
/*     DECLARAION OF DATA TYPES                                                       */  
/**************************************************************************************/
typedef signed short   INT16S;
typedef signed int     INT32S;
typedef unsigned short INT16U;
typedef unsigned int   INT32U;
typedef char           INT8U;
typedef double         FP64;
typedef float          FP32;

/* BEAMFORMING CONFIG STRUCTURE */

#define CFG_MAX		1000	/* maximum allowed size for array in CFG structure */

typedef struct cfg_struct{
	/* common parameters */
    INT32S    tx_ant_type;		/* TX antenna type parameter */
    INT32S    rx_ant_type;      /* RX antenna type parameter */	

	/* steerable antenna related parameters */
    FP64	  tx_sec_bound;	    /* TX spherical sector bound for antenna beam search */
    FP64	  rx_sec_bound;	    /* RX spherical sector bound for antenna beam search */
	FP64      tx_hpbw;			/* TX half-power antenna beam width in [deg] */
    FP64      rx_hpbw;			/* RX half-power antenna beam width in [deg] */

	/* angles set using for exhaustive search in TX and RX sides */
	INT32S	  size_tx;			/* TX array size */
	FP64      tx_az[CFG_MAX];	/* TX azimuth angles array */
	FP64      tx_el[CFG_MAX];	/* TX elevation angles array */
	INT32S	  size_rx;			/* RX array size */
	FP64      rx_az[CFG_MAX];	/* RX azimuth angles array */
	FP64      rx_el[CFG_MAX];	/* RX elevation angles array */
}   CFG;

/* BEAMFORMING CHANNEL STRUCTURE */

#define CH_MAX		1000	/* maximum allowed size for array in CH structure */

typedef struct ch_struct{
	/* common parameters */
	INT32S	  size;				/* am array size */
	FP64	  am_r[CH_MAX];		/* array of real parts of complex amplitudes */
	FP64	  am_i[CH_MAX];		/* array of imag parts of complex amplitudes */
	FP64	  tx_az[CH_MAX];	/* TX azimuth angles array */
	FP64	  tx_el[CH_MAX];	/* TX elevation angles array */
	FP64	  rx_az[CH_MAX];	/* RX azimuth angles array */
	FP64	  rx_el[CH_MAX];	/* RX elevation angles array */
}   CH;

/**************************************************************************************/
/*     DECLARATION OF FUNCTIONS									    				  */
/**************************************************************************************/

/* exhaustive_search.c */
void    exhaustive_search	(CFG	*cfg_p,
							 CH		*ch_p,
							 FP64	*imp_res_r,
							 FP64	*imp_res_i);

/* ant_gain.c */
double	ant_gain			(INT32S ant_type,
                             FP64   hpbw,
							 INT32S size,
							 FP64   *am_r,
							 FP64   *am_i,
							 FP64   *az,
							 FP64   *el,
							 FP64   az_rot,
							 FP64   el_rot,
							 FP64   *amg_r,
							 FP64   *amg_i,
							 FP64	power);

/* basic2rot.c */
void	basic2rot			(INT32S size,
							 FP64   *az,
							 FP64	*el,
							 FP64	az_rot,
							 FP64	el_rot,
							 FP64	self_rot,
							 FP64	*azr,
							 FP64	*elr);

/* steer_antenna.c */
double	steer_antenna		(INT32S size,
							 FP64	*am_r,
							 FP64	*am_i,
							 FP64	*el,
							 FP64	hpbw,
							 FP64	*amg_r,
							 FP64	*amg_i,
							 FP64	power);

#endif
