 /*************************************************************************************
	Intel Corp.

    Project Name:  60 GHz Channel Model
    File Name:     exhaustive_search.c
    Authors:       A. Lomayev, R. Maslennikov
    Version:       5.0
    History:       May 2010 created

  *************************************************************************************
    Description:

    function performs exhaustive search for TX and RX sides in accordance
    with TX and RX angles grids
    
  *************************************************************************************/

void exhaustive_search(CFG *cfg_p, CH *ch_p, FP64 *imp_res_r, FP64 *imp_res_i)
{
	/* pointers */
	INT32S i, j, k;

	/* maximum received power */
	FP64 power_max;

	/* current receiving power corresponding to i-th TX and j-th RX spatial beams positions */
	FP64 power_cur;	

	/* array of amplitudes after antenna weighting on TX and RX sides */
	FP64 *tx_am_r, *tx_am_i, *rx_am_r, *rx_am_i;

	/* antenna beam rotation angles for TX and RX */
	FP64 tx_az_rot, tx_el_rot, rx_az_rot, rx_el_rot;

	
    /* allocate memory for tx_am */
	tx_am_r = (FP64 *)MEM_CALLOC(ch_p->size,sizeof(FP64));
	tx_am_i = (FP64 *)MEM_CALLOC(ch_p->size,sizeof(FP64));

	/* allocate memory for rx_am */
	rx_am_r = (FP64 *)MEM_CALLOC(ch_p->size,sizeof(FP64));
	rx_am_i = (FP64 *)MEM_CALLOC(ch_p->size,sizeof(FP64));

	/* initialize power variables */
	power_max = 0;
	power_cur = 0;

	/* initialize imp_res */
	for (k=0; k<ch_p->size; k++)
	{
		imp_res_r[k] = ch_p->am_r[k];
		imp_res_i[k] = ch_p->am_i[k];
	}

		
	/* space filtering */
	/* TX search */
	for (i=0; i<cfg_p->size_tx; i++)
	{
		tx_az_rot = cfg_p->tx_az[i];
		tx_el_rot = cfg_p->tx_el[i];

		/* TX antenna gain */
		power_cur = ant_gain(cfg_p->tx_ant_type, cfg_p->tx_hpbw, ch_p->size, ch_p->am_r, ch_p->am_i, ch_p->tx_az, ch_p->tx_el, tx_az_rot, tx_el_rot, tx_am_r, tx_am_i, power_cur);
		
		/* RX search */
		for (j=0; j<cfg_p->size_rx; j++)
		{
			rx_az_rot = cfg_p->rx_az[j];
			rx_el_rot = cfg_p->rx_el[j];

			/* RX antenna gain */
			power_cur = ant_gain(cfg_p->rx_ant_type, cfg_p->rx_hpbw, ch_p->size, tx_am_r, tx_am_i, ch_p->rx_az, ch_p->rx_el, rx_az_rot, rx_el_rot, rx_am_r, rx_am_i, power_cur);

			/* max power selection */
			if (power_cur > power_max)
			{
				power_max = power_cur;
				for (k=0; k<ch_p->size; k++)
				{
					imp_res_r[k] = rx_am_r[k];
					imp_res_i[k] = rx_am_i[k];					
				}
			}
		}
	}
	
	
	/* free tx_am */
	MEM_FREE(tx_am_r);
	MEM_FREE(tx_am_i);
	/* free rx_am */
	MEM_FREE(rx_am_r);
	MEM_FREE(rx_am_i);	
}