 /*************************************************************************************
    Intel Corp.

    Project Name:  60 GHz Channel Model
    File Name:     exhaustive_search_mex.c
    Authors:       A. Lomayev, R. Maslennikov
    Version:       5.0
    History:       May 2010 created

  *************************************************************************************
    Description:

    Interface to Matlab for exhaustive_search.c function	

  *************************************************************************************/

#include "mex_include.h"

void mexFunction (int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	/* INPUT DECLARATIONS */
	mxArray		*tmp;
	INT32S		ant_type_fnum, sec_bound_fnum, hpbw_fnum;
	INT32S		tx_az_fnum, tx_el_fnum, rx_az_fnum, rx_el_fnum, am_fnum;
	INT32S		k, AL;
	
	/* OUPTUT DECLARATIONS */
	CFG			cfg;
	CH			ch;
	FP64		*imp_res_r;
	FP64		*imp_res_i;

	/* Error messages */
	char		errMsg[150];

	/* INPUT SECTION:  Get Initialization data from MATLAB */

	/* Check for proper number of input and  output arguments */    
    if (nrhs !=2) {
        mexErrMsgTxt("Two inputs are required.");
    }
    else if (nlhs > 1) {
        mexErrMsgTxt("Too many output arguments.");
    }
    else if(!mxIsStruct(prhs[0])){
        mexErrMsgTxt("First input must be a structure.");
	}
	else if(!mxIsStruct(prhs[1])){
        mexErrMsgTxt("Second input must be a structure.");
	}

	/* FILL CFG STRUCTURE */

    /* get TX antenna type */
    ant_type_fnum = mxGetFieldNumber(prhs[0], "tx_ant_type");
    tmp = mxGetFieldByNumber(prhs[0], 0, ant_type_fnum);
	if(mxGetNumberOfElements(tmp) != 1) {
        mexErrMsgTxt("Filed 'tx_ant_type' must be scalar.");
    }	
    /* TX ant_type -> cfg structure */
	cfg.tx_ant_type = (INT32S)*(mxGetPr(tmp));
	if((cfg.tx_ant_type!=0) & (cfg.tx_ant_type!=1))
	{
		mexErrMsgTxt("Prohibited value of 'cfg.tx_ant_type' parameter.");
	}
    
    /* get RX antenna type */
    ant_type_fnum = mxGetFieldNumber(prhs[0], "rx_ant_type");
    tmp = mxGetFieldByNumber(prhs[0], 0, ant_type_fnum);
	if(mxGetNumberOfElements(tmp) != 1) {
        mexErrMsgTxt("Filed 'rx_ant_type' must be scalar.");
    }	
    /* RX ant_type -> cfg structure */
	cfg.rx_ant_type = (INT32S)*(mxGetPr(tmp));
	if((cfg.rx_ant_type!=0) & (cfg.rx_ant_type!=1))
	{
		mexErrMsgTxt("Prohibited value of 'cfg.rx_ant_type' parameter.");
	}
    		
	/* get TX sector bound */
    sec_bound_fnum = mxGetFieldNumber(prhs[0], "tx_sec_bound");
    tmp = mxGetFieldByNumber(prhs[0], 0, sec_bound_fnum);
	if(mxGetNumberOfElements(tmp) != 1) {
        mexErrMsgTxt("Filed 'tx_sec_bound' must be scalar.");
    }
    /* TX sec_bound -> cfg structure */
	cfg.tx_sec_bound = (FP64)*(mxGetPr(tmp));
    
    /* get RX sector bound */
    sec_bound_fnum = mxGetFieldNumber(prhs[0], "rx_sec_bound");
    tmp = mxGetFieldByNumber(prhs[0], 0, sec_bound_fnum);
	if(mxGetNumberOfElements(tmp) != 1) {
        mexErrMsgTxt("Filed 'rx_sec_bound' must be scalar.");
    }
    /* RX sec_bound -> cfg structure */
	cfg.rx_sec_bound = (FP64)*(mxGetPr(tmp));
	
    /* get TX hpbw */
    hpbw_fnum = mxGetFieldNumber(prhs[0], "tx_hpbw");
    tmp = mxGetFieldByNumber(prhs[0], 0, hpbw_fnum);
	if(mxGetNumberOfElements(tmp) != 1) {
        mexErrMsgTxt("Filed 'tx_hpbw' must be scalar.");
    }
    /* TX hpbw -> cfg structure */
	cfg.tx_hpbw = (FP64)*(mxGetPr(tmp));	
	
    /* get RX hpbw */
    hpbw_fnum = mxGetFieldNumber(prhs[0], "rx_hpbw");
    tmp = mxGetFieldByNumber(prhs[0], 0, hpbw_fnum);
	if(mxGetNumberOfElements(tmp) != 1) {
        mexErrMsgTxt("Filed 'rx_hpbw' must be scalar.");
    }
    /* RX hpbw -> cfg structure */
	cfg.rx_hpbw = (FP64)*(mxGetPr(tmp));
    
    
    /* get tx_az array */
	tx_az_fnum = mxGetFieldNumber(prhs[0], "tx_az");
    tmp = mxGetFieldByNumber(prhs[0], 0, tx_az_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CFG_MAX) {
		sprintf(errMsg,"Size of array 'cfg.tx_az' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CFG_MAX);
		mexErrMsgTxt(errMsg);        
    }
	/* size_tx -> cfg structure */
	cfg.size_tx = AL;	
	/* tx_az -> cfg structure */
    for (k=0; k<AL; k++) {
        cfg.tx_az[k] = (FP64)*(mxGetPr(tmp)+k);		
	}

	/* get tx_el array */
	tx_el_fnum = mxGetFieldNumber(prhs[0], "tx_el");
    tmp = mxGetFieldByNumber(prhs[0], 0, tx_el_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CFG_MAX) {
		sprintf(errMsg,"Size of array 'cfg.tx_el' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CFG_MAX);
		mexErrMsgTxt(errMsg);
    }
	/* tx_el -> cfg structure */
    for (k=0; k<AL; k++) {
        cfg.tx_el[k] = (FP64)*(mxGetPr(tmp)+k);		
	}

	/* get rx_az array */
	rx_az_fnum = mxGetFieldNumber(prhs[0], "rx_az");
    tmp = mxGetFieldByNumber(prhs[0], 0, rx_az_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CFG_MAX) {
		sprintf(errMsg,"Size of array 'cfg.rx_az' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CFG_MAX);
		mexErrMsgTxt(errMsg);        
    }
	/* size_rx -> cfg structure */
	cfg.size_rx = AL;
	/* rx_az -> cfg structure */
    for (k=0; k<AL; k++) {
        cfg.rx_az[k] = (FP64)*(mxGetPr(tmp)+k);
	}

	/* get rx_el array */
	rx_el_fnum = mxGetFieldNumber(prhs[0], "rx_el");
    tmp = mxGetFieldByNumber(prhs[0], 0, rx_el_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CFG_MAX) {
		sprintf(errMsg,"Size of array 'cfg.rx_el' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CFG_MAX);
		mexErrMsgTxt(errMsg);         
    }
	/* rx_el -> cfg structure */
    for (k=0; k<AL; k++) {
        cfg.rx_el[k] = (FP64)*(mxGetPr(tmp)+k);
	}

	/* FILL CH STRUCTURE */
	
	/* get am array */
	am_fnum = mxGetFieldNumber(prhs[1], "am");
    tmp = mxGetFieldByNumber(prhs[1], 0, am_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CH_MAX) {
		sprintf(errMsg,"Size of array 'ch.am' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CH_MAX);
		mexErrMsgTxt(errMsg);
    }
	/* am size -> ch structure */
	ch.size = AL;
	/* am -> cfg structure */
    for (k=0; k<AL; k++) {
        ch.am_r[k] = (FP64)*(mxGetPr(tmp)+k);
		ch.am_i[k] = (FP64)*(mxGetPi(tmp)+k);		
	}

	/* get tx_az array */
	tx_az_fnum = mxGetFieldNumber(prhs[1], "tx_az");
    tmp = mxGetFieldByNumber(prhs[1], 0, tx_az_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CH_MAX) {
		sprintf(errMsg,"Size of array 'ch.tx_az' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CH_MAX);
		mexErrMsgTxt(errMsg);        
    }
	/* tx_az -> ch structure */
    for (k=0; k<AL; k++) {
        ch.tx_az[k] = (FP64)*(mxGetPr(tmp)+k);		
	}

	/* get tx_el array */
	tx_el_fnum = mxGetFieldNumber(prhs[1], "tx_el");
    tmp = mxGetFieldByNumber(prhs[1], 0, tx_el_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CH_MAX) {
		sprintf(errMsg,"Size of array 'ch.tx_el' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CH_MAX);
		mexErrMsgTxt(errMsg);          
    }
	/* tx_el -> ch structure */
    for (k=0; k<AL; k++) {
        ch.tx_el[k] = (FP64)*(mxGetPr(tmp)+k);		
	}

	/* get rx_az array */
	rx_az_fnum = mxGetFieldNumber(prhs[1], "rx_az");
    tmp = mxGetFieldByNumber(prhs[1], 0, rx_az_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CH_MAX) {
		sprintf(errMsg,"Size of array 'ch.rx_az' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CH_MAX);
		mexErrMsgTxt(errMsg);          
    }
	/* rx_az -> ch structure */
    for (k=0; k<AL; k++) {
        ch.rx_az[k] = (FP64)*(mxGetPr(tmp)+k);		
	}

	/* get rx_el array */
	rx_el_fnum = mxGetFieldNumber(prhs[1], "rx_el");
    tmp = mxGetFieldByNumber(prhs[1], 0, rx_el_fnum);
	AL = (INT32S)mxGetNumberOfElements(tmp);
	if(AL > CH_MAX) {
		sprintf(errMsg,"Size of array 'ch.rx_el' must be less or equal to %d, to extand it for larger sizes please change defaults in bf.h.", CH_MAX);
		mexErrMsgTxt(errMsg);         
    }
	/* rx_el -> ch structure */
    for (k=0; k<AL; k++) {
        ch.rx_el[k] = (FP64)*(mxGetPr(tmp)+k);		
	}

	/* CALL USER FUNCTION, OUTPUT SECTION */

	plhs[0] = mxCreateDoubleMatrix(1, ch.size, mxCOMPLEX);

	imp_res_r = mxGetPr(plhs[0]);
	imp_res_i = mxGetPi(plhs[0]);

	exhaustive_search(&cfg, &ch, imp_res_r, imp_res_i);	
}
