 /*************************************************************************************
	Intel Corp.

    Project Name:  60 GHz Channel Model
    File Name:     steer_antenna.c
    Authors:       A. Lomayev, R. Maslennikov
    Version:       5.0
    History:       May 2010 created

  *************************************************************************************
    Description:
 
    function returns amplitudes weighted by gain coefficients calculated
    for steerable antenna model

  *************************************************************************************/

double steer_antenna(INT32S size, FP64 *am_r, FP64 *am_i, FP64 *el, FP64 hpbw, FP64 *amg_r, FP64 *amg_i, FP64 power)
{
	/* pointers */
	INT32S i;
	/* maximum antenna gain coefficient */
	FP64 G0;
	/* main-lobe width */
	FP64 theta_ml;
	/* side-lobe antenna gain level */
	FP64 G_side;
	/* main-lobe antenna gain */
	FP64 G;


	/* calculate antenna gain function in accordance with hpbw parameter */
	G0 = 20*log10(1.6162/sin((hpbw*D2R)/2));
	theta_ml = 2.6*hpbw;
	G_side = -0.4111*log(hpbw)-10.597;

	/* initialize power variable */
	power = 0;
	for (i=0; i<size; i++)
	{
		if (fabs(el[i]) > (theta_ml/2))
			G = G_side;
		else
			G = G0 - 3.01 * pow((2*fabs(el[i])/hpbw),2);

		G = pow(10,(G/20));

		amg_r[i] = G*am_r[i];
		amg_i[i] = G*am_i[i];

		power = power + pow(amg_r[i],2) + pow(amg_i[i],2);
	}
	return power;
}