% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Conference Room Channel Model
%    File Name:     cr_ap_toa_2nd.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates times of arrival in [ns] for 2nd order clusters
%    obtained from wall reflections in CR environment for STA-AP subscenario
%
%    [y] = cr_ap_toa_2nd(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - times of arrival array
%
%  *************************************************************************************/
function y = cr_ap_toa_2nd(size)

u = rand(1,size);

x = [4,6,8,13,16,20,23,25,28,30];
z = [0,86773,2453,79978,26041,27128,0,0,48049,0]./800000;

a(1) = (z(1)-z(2))./(x(1)-x(2));
b(1) = (z(2).*x(1)-z(1).*x(2))./(x(1)-x(2));

a(2) = (z(2)-z(3))./(x(2)-x(3));
b(2) = (z(3).*x(2)-z(2).*x(3))./(x(2)-x(3));

a(3) = (z(3)-z(4))./(x(3)-x(4));
b(3) = (z(4).*x(3)-z(3).*x(4))./(x(3)-x(4));

a(4) = (z(4)-z(5))./(x(4)-x(5));
b(4) = (z(5).*x(4)-z(4).*x(5))./(x(4)-x(5));

a(5) = (z(5)-z(6))./(x(5)-x(6));
b(5) = (z(6).*x(5)-z(5).*x(6))./(x(5)-x(6));

a(6) = (z(6)-z(7))./(x(6)-x(7));
b(6) = (z(7).*x(6)-z(6).*x(7))./(x(6)-x(7));

a(7) = (z(7)-z(8))./(x(7)-x(8));
b(7) = (z(8).*x(7)-z(7).*x(8))./(x(7)-x(8));

a(8) = (z(8)-z(9))./(x(8)-x(9));
b(8) = (z(9).*x(8)-z(8).*x(9))./(x(8)-x(9));

a(9) = (z(9)-z(10))./(x(9)-x(10));
b(9) = (z(10).*x(9)-z(9).*x(10))./(x(9)-x(10));


c(1) = -(a(1)./2).*(x(1).^2) - b(1).*x(1);
u1 = (a(1)./2).*(x(2).^2) + b(1).*x(2) + c(1);

c(2) = u1 - (a(2)./2).*(x(2).^2) - b(2).*x(2);
u2 = (a(2)./2).*(x(3).^2) + b(2).*x(3) + c(2);

c(3) = u2 - (a(3)./2).*(x(3).^2) - b(3).*x(3);
u3 = (a(3)./2).*(x(4).^2) + b(3).*x(4) + c(3);

c(4) = u3 - (a(4)./2).*(x(4).^2) - b(4).*x(4);
u4 = (a(4)./2).*(x(5).^2) + b(4).*x(5) + c(4);

c(5) = u4 - (a(5)./2).*(x(5).^2) - b(5).*x(5);
u5 = (a(5)./2).*(x(6).^2) + b(5).*x(6) + c(5);

c(6) = u5 - (a(6)./2).*(x(6).^2) - b(6).*x(6);
u6 = (a(6)./2).*(x(7).^2) + b(6).*x(7) + c(6);

c(7) = u6 - (a(7)./2).*(x(7).^2) - b(7).*x(7);
u7 = (a(7)./2).*(x(8).^2) + b(7).*x(8) + c(7);

c(8) = u7 - (a(8)./2).*(x(8).^2) - b(8).*x(8);
u8 = (a(8)./2).*(x(9).^2) + b(8).*x(9) + c(8);

c(9) = u8 - (a(9)./2).*(x(9).^2) - b(9).*x(9);

index = find((u >= 0) & (u <= u1));
y(index) = (-b(1) + sqrt(b(1).^2 - 2.*a(1).*(c(1)-u(index))))./a(1);
index = find((u > u1) & (u <= u2));
y(index) = (-b(2) + sqrt(b(2).^2 - 2.*a(2).*(c(2)-u(index))))./a(2);
index = find((u > u2) & (u <= u3));
y(index) = (-b(3) + sqrt(b(3).^2 - 2.*a(3).*(c(3)-u(index))))./a(3);
index = find((u > u3) & (u <= u4));
y(index) = (-b(4) + sqrt(b(4).^2 - 2.*a(4).*(c(4)-u(index))))./a(4);
index = find((u > u4) & (u <= u5));
y(index) = (-b(5) + sqrt(b(5).^2 - 2.*a(5).*(c(5)-u(index))))./a(5);
index = find((u > u5) & (u <= u6));
y(index) = (-b(6) + sqrt(b(6).^2 - 2.*a(6).*(c(6)-u(index))))./a(6);
index = find((u > u6) & (u <= u7));
y(index) = (-b(7) + sqrt(b(7).^2 - 2.*a(7).*(c(7)-u(index))))./a(7);
index = find((u > u7) & (u <= u8));
y(index) = (-b(8) + sqrt(b(8).^2 - 2.*a(8).*(c(8)-u(index))))./a(8);
index = find((u > u8) & (u <= 1));
y(index) = (-b(9) + sqrt(b(9).^2 - 2.*a(9).*(c(9)-u(index))))./a(9);