% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Enterprise Cubicle Channel Model
%    File Name:     cb_cls_prob.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates clusters probabilities
%
%    [P] = cb_cls_prob(cfg)
%
%    Inputs:
%
%       1. cfg.scen - parameter selects laptop location scenario: 0 - near laptop location, 1 - far laptop location
%       2. cfg.Plos - LOS (Line-of-Sight) parameter, permitted values: 0 - corresponds to NLOS scenario, 1 - corresponds to LOS scenario
%       3. cfg.D    - distance in [meters] between TX and RX
%
%    Outputs:
%
%       1. P - array of clusters probabilities
%
%    Dimension of P array:
%
%    Near laptop location scenario
%
%       1 - OW#1 cluster
%       2 - CW#4 cluster
%       3 - Table cluster
%       4 - Table-Ceiling cluster
%
%    Far laptop location scenario
%
%       1 - OW#1 cluster (cubicles #1,2)
%       2 - OW#2 cluster (cubicles #1,2)
%       3 - CW#1 cluster in cubicle #1 (or CW#3 cluster in cubicle #2)
%       4 - CW#2 cluster (cubicles #1,2)
%       5 - Table cluster (cubicles #1,2)
%
%  *************************************************************************************/
function [P] = cb_cls_prob(cfg)

p_cls = rand(1,1);

switch (cfg.scen)
    case 0, % near laptop location
        if (p_cls <= 0.5)
            if (rand(1,1) <= 0.9)
                P = [1,0,1,1];
            else
                P = [1,1,0,1];
            end
        else
            P = [1,1,1,1];
        end
        
    case 1, % far laptop location        
        if (p_cls <= 0.5)
            P = [1,1,0,1,0];            
        elseif ( (p_cls > 0.5) && (p_cls <= 0.7) )           
            if (rand(1,1) <= 0.8)
                P = [1,1,0,1,1];
            else
                P = [1,1,1,1,0];
            end            
        else
            P = [1,1,1,1,1];    
        end
        if (cfg.Plos == 0)
            P(5) = 0;
        end
    otherwise,
        error('Prohibited value of "scen" parameter');
end