% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Enterprise Cubicle Channel Model
%    File Name:     cb_gen_inter_cls_nl.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function returns NLOS space-temporal clusters parameters: azimuth/elevation angles
%    in [deg] relative to LOS direction for TX/RX, times of arrival in [ns] relative
%    to LOS time for Enterprise Cubicle environment for Near laptop location
%
%    [cls] = cb_gen_inter_cls_nl(N)
%
%    Inputs:
%
%       1. N - the number of realizations
%
%    Outputs:
%
%       Near laptop location:
%
%        1.  cls.toa   - times of arrival array, size 3xN
%        2.  cls.tx_az - TX azimuths array,      size 3xN
%        3.  cls.tx_el - TX elevations array,    size 3xN
%        4.  cls.rx_az - RX azimuths array,      size 3xN
%        5.  cls.rx_el - RX elevations array,    size 3xN
%
%    Row dimension in cls.x array:
%
%    1 - OW#1 cluster
%    2 - CW#4 cluster
%    3 - Table cluster
%    4 - Table-Ceiling cluster
%
%  *************************************************************************************/
function [cls] = cb_gen_inter_cls_nl(N)

% time of arrival
cls.toa(1,:) = 5 + 8.*rand(1,N);
cls.toa(2,:) = 4.*rand(1,N);
cls.toa(3,:) = ones(1,N);
cls.toa(4,:) = 13 + 3.*rand(1,N);

% tx azimuth
cls.tx_az(1,:) = 2 + 68.*rand(1,N);
cls.tx_az(2,:) = 18.*rand(1,N);
cls.tx_az(3,:) = zeros(1,N);
cls.tx_az(4,:) = zeros(1,N);

% tx elevation
cls.tx_el(1,:) = -28 + 9.*rand(1,N);
cls.tx_el(2,:) = -46 + 9.*rand(1,N);
cls.tx_el(3,:) = -86 + 36.*rand(1,N);
cls.tx_el(4,:) = -88 + 15.*rand(1,N);

% rx azimuth
cls.rx_az(1,:) = -173 + 75.*rand(1,N);
cls.rx_az(2,:) = -171 + 56.*rand(1,N);
cls.rx_az(3,:) = zeros(1,N);
cls.rx_az(4,:) = zeros(1,N);

% rx elevation
cls.rx_el(1,:) = -cls.tx_el(1,:);
cls.rx_el(2,:) = -cls.tx_el(2,:);
cls.rx_el(3,:) = cls.tx_el(3,:);
cls.rx_el(4,:) = -cls.tx_el(4,:);