% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Enterprise Cubicle Channel Model
%    File Name:     cb_pen_loss.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function returns clusters penetration loss according to normal distribution based
%    on the experimental data
%
%    [pen_loss] = cb_pen_loss()
%
%    Outputs:
%
%       1. pen_loss - penetration loss coefficients array
%
%    Inputs:
%
%       1. scen  - parameter selects laptop location scenario: 0 - near laptop location, 1 - far laptop location
%       2. ps    - polarization support parameter: 0 - TX/RX polarization vectors are not applied, 1 - polarization is applied
%       3. pol   - antennas polarization type 1x2 vector: pol(1) - polarization type for TX antenna, pol(2) - polarization type for RX antenna 
%
%
%    Row dimension in ref_loss array:
%
%    Near laptop location scenario
%
%    1 - OW#1 cluster
%    2 - CW#4 cluster
%    3 - Table cluster
%    4 - Table-Ceiling cluster
%
%    Far laptop location scenario
%
%    1 - OW#1 cluster (cubicles #1,2)
%    2 - OW#2 cluster (cubicles #1,2)
%    3 - CW#1 cluster in cubicle #1 (or CW#3 cluster in cubicle #2)
%    4 - CW#2 cluster (cubicles #1,2)
%    5 - Table cluster (cubicles #1,2)
%
%  *************************************************************************************/
function [pen_loss] = cb_pen_loss(scen,ps,pol)

pen_coef = -6;

switch (scen)
    case 0, % near laptop location
        pen_loss_db = [pen_coef;0;0;0];
    case 1, % far laptop location
        pen_loss_db = [pen_coef;pen_coef;0;0;0];
    otherwise,
        error('Prohibited value of "scen" parameter');
end

pen_loss = 10.^(pen_loss_db./20);