% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_az_1st_side_rx.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates azimuth angles in [deg] for 1st order clusters obtained from wall
%    reflections in LR environment on RX side
%
%    [az_small, az_large] = lr_az_1st_side_rx(size)
%
%    Inputs:
%
%       1. size - target size of returned arrays
%
%    Outputs:
%
%       1. az_small - small azimuth angles array
%       2. az_large - large azimuth angles array
% 
%  *************************************************************************************/
function [az_small, az_large] = lr_az_1st_side_rx(size)

% sector parameters
a = 82./52;
b = 60;
sigma = 15;

sh_bound = 90;
ln_bound = 150;

for i=1:size
    az_large(i) = 151;
    while (az_large(i) > 150)
        az_small(i) = rand(1,1).*sh_bound;
        az_large(i) = (a.*az_small(i) + b) + sigma.*(rand(1,1));
    end
end