% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_az_1st_side_tx.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates azimuth angles in [deg] for 1st order clusters obtained from wall
%    reflections in LR environment on TX side
%
%    [az_small, az_large] = lr_az_1st_side_tx(size)
%
%    Inputs:
%
%       1. size - target size of returned arrays
%
%    Outputs:
%
%       1. az_small - small azimuth angles array
%       2. az_large - large azimuth angles array
% 
%  *************************************************************************************/
function [az_small, az_large] = lr_az_1st_side_tx(size)

sigma = 180 - ((82./62).*52+2423./31);

for i=1:size
    
    az_large(i) = 181;
    bound2 = 180;
    
    while (az_large(i) > bound2)
        
        az_small(i) = 15 + 62.*rand(1,1);
        
        bound1 = (82./62).*az_small(i)+2423./31;
        
        if (az_small(i) < 52)
            bound2 = (82./37).*az_small(i)+2396./37;
        else
            bound2 = 180;
        end
        
        az_large(i) = bound1 + sigma.*rand(1,1);
    end
end