% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_az_2nd_side14.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates azimuth angles in [deg] for 2nd order clusters obtained from 
%    perpendicular walls 1-4 (4-1) reflections in LR environment on TX side
%
%    [y] = lr_az_2nd_side14(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - azimuth angles array
% 
%  *************************************************************************************/
function [y] = lr_az_2nd_side14(size)

u = rand(1,size);

x = [-180,-129,73,180];

a = 2./423;
b = 0;
d = 3./423;

c(1) = -a.*x(1);
u1 = a.*x(2) + c(1);

c(2) = u1 - x(2).*b;
u2 = b.*x(3) + c(2);

c(3) = u2 - x(3).*d;

index = find((u >= 0) & (u < u1));
y(index) = (u(index) - c(1))./a;
index = find((u >= u1) & (u <= u2));
y(index) = (u(index) - c(2))./b;
index = find((u >= u2) & (u <= 1));
y(index) = (u(index) - c(3))./d;