% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_az_2nd_side42.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates azimuth angles in [deg] for 2nd order clusters obtained from 
%    parallel walls 4-2 reflections in LR environment
%
%    [y] = lr_az_2nd_side42(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - azimuth angles array
% 
%  *************************************************************************************/
function [y] = lr_az_2nd_side42(size)

y = 130.*rand(1,size) + 18;