% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_cls_prob.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates clusters probabilities
%
%    [P] = lr_cls_prob(cfg)
%
%    Inputs:
%
%       1. cfg.P_1st_c  - probability of 1st order reflections from ceiling
%       2. cfg.P_1st_f  - probability of 1st order reflections from floor
%       3. cfg.P_1st_w  - probability of 1st order reflections from walls
%       4. cfg.P_2nd_w  - probability of 2nd order reflections from two walls
%       5. cfg.P_2nd_cf - probability of 2nd order reflections from ceiling and floor
%       6. cfg.P_2nd_wc - probability of 2nd order wall-ceiling (ceiling-wall) reflections
%       7. cfg.P_2nd_wf - probability of 2nd order wall-floor (floor-wall) reflections
%
%    Outputs:
%
%       1. P - array of clusters probabilities
% 
%  *************************************************************************************/
function [P] = lr_cls_prob(cfg)

% 1st order reflections from ceiling
P(1) = cfg.P_1st_c;
% 1st order reflections from floor
P(2) = cfg.P_1st_f;
% 1st order reflections from walls
P(3:5) = cfg.P_1st_w;
% 2nd order reflections from two walls
P(6:10) = cfg.P_2nd_w;
% 2nd order reflections from ceiling and floor
P(11:12) = cfg.P_2nd_cf;
% 2nd order reflections from the wall and ceiling and from the wall and floor
P(13:18) = repmat([cfg.P_2nd_wc,cfg.P_2nd_wf],1,3);