% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_el_1st.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates elevation angles in [deg] for 1st order clusters obtained from ceiling 
%    (floor) reflections in LR environment
%
%    [y] = lr_el_1st(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - elevation angles array
%
%  *************************************************************************************/
function [y] = lr_el_1st(size)

u = rand(1,size);

x = [25,29,62.5];

a = [ 0.01320   -0.00155];
b = [-0.33000    0.09761];

c(1) = (b(1).^2 - (b(1)+x(1).*a(1)).^2)./(2.*a(1));

umax = ((a(1).*x(2)+b(1)).^2-(b(1).^2-2.*a(1).*c(1)))./(2.*a(1));

c(2) = ((b(2).^2+2.*a(2).*umax)-(x(2).*a(2)+b(2)).^2)./(2.*a(2));

index = find((u >= 0) & (u < umax));
y(index) = (-b(1) + sqrt(b(1).^2 - 2.*a(1).*(c(1)-u(index))))./a(1);
index = find((u >= umax) & (u <= 1));
y(index) = (-b(2) + sqrt(b(2).^2 - 2.*a(2).*(c(2)-u(index))))./a(2);