% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_el_2nd_side_up1.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates elevation angles in [deg] for 2nd order clusters obtained from
%    wall #1 - ceiling reflections in LR environment
%
%    [y] = lr_el_2nd_side_up1(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - azimuth angles array
%
%  *************************************************************************************/
function [y] = lr_el_2nd_side_up1(size)

u = rand(1,size);

y = 12 + 8.*u;