% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_el_2nd_side_up3.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates elevation angles in [deg] for 2nd order clusters obtained from
%    ceiling - wall #2,4 reflections in LR environment
%
%    [y] = lr_el_2nd_side_up3(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - azimuth angles array
%
%  *************************************************************************************/
function [y] = lr_el_2nd_side_up3(size)

u = rand(1,size);

y = 13 + 11.*u;