% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_gen_inter_cls.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function returns NLOS space-temporal clusters parameters: azimuth/elevation angles
%    in [deg] relative to LOS direction for TX/RX, times of arrival in [ns] relative
%    to LOS time for LR environment
%
%    [cls] = lr_gen_inter_cls(N)
%
%    Inputs:
%
%       1. N - the number of realizations
%
%    Outputs:
%
%        1. cls.toa   - times of arrival array, size 18xN
%        2. cls.tx_az - TX azimuths array,      size 18xN
%        3. cls.tx_el - TX elevations array,    size 18xN
%        4. cls.rx_az - RX azimuths array,      size 18xN
%        5. cls.rx_el - RX elevations array,    size 18xN
%
%    Row dimension in cls.x array:
%
%    1,2                     - 1st order reflections from ceiling and floor
%    3,4,5                   - 1st order reflections from walls
%
%    6,7,8,9,10              - 2nd order reflections from two walls
%    11,12                   - 2nd order reflections from ceiling and floor
%    13,14,15,16,17,18       - 2nd order reflections from the wall and
%                              ceiling and from the wall and floor
%
%  *************************************************************************************/
function [cls] = lr_gen_inter_cls(N)

% times of arrival
toa_1 = lr_toa_1st_up(N);

cls.toa(1:2,:) = [toa_1;toa_1];

toa_3 = lr_toa_1st_side(N);
toa_5 = lr_toa_1st_side(N);
toa_7 = lr_toa_1st_side(N);

cls.toa(3:5,:) = [toa_3;toa_5;toa_7];

toa_6  = lr_toa_2nd_side(N);
toa_7  = lr_toa_2nd_side(N);
toa_8  = lr_toa_2nd_side(N);
toa_9  = lr_toa_2nd_side(N);
toa_10 = lr_toa_2nd_side(N);

cls.toa(6:10,:) = [toa_6;toa_7;toa_8;toa_9;toa_10];

toa_11 = lr_toa_2nd_up_down(N);

cls.toa(11:12,:) = [toa_11;toa_11];

toa_13 = lr_toa_2nd_side_up(N);
toa_14 = lr_toa_2nd_side_up(N);
toa_15 = lr_toa_2nd_side_up(N);
toa_16 = lr_toa_2nd_side_up(N);
toa_17 = lr_toa_2nd_side_up(N);
toa_18 = lr_toa_2nd_side_up(N);

cls.toa(13:18,:) = [toa_13;toa_14;toa_15;toa_16;toa_17;toa_18];

% tx azimuths
cls.tx_az(1:2,:) = zeros(2,N);

[az_small_p, az_large_p] = lr_az_1st_side_tx(N);
[az_small_n, az_large_n] = lr_az_1st_side_tx(N);

p = rand(1,1);

if p <= 0.5
    cls.tx_az(3:5,:) = [-az_large_n;az_small_p;az_large_p];
else
    cls.tx_az(3:5,:) = [-az_large_n;-az_small_n;az_large_p];
end


i = 0;
while (i<N)    
    tx_az_12(i+1) = lr_az_2nd_side12(1);
    tx_az_14(i+1) = lr_az_2nd_side14(1);
    if (tx_az_12(i+1) >= 129) && (tx_az_14(i+1) <= -129)
        i = i + 0;
    else
        i = i + 1;
    end
end

cls.tx_az(6:7,:) = [tx_az_12;tx_az_14];

tx_az_42 =  lr_az_2nd_side42(N);
tx_az_24 = -lr_az_2nd_side42(N);
tx_az_31 =  lr_az_2nd_side31(N);

cls.tx_az(8:10,:) = [tx_az_42;tx_az_24;tx_az_31];

cls.tx_az(11:12,:) = zeros(2,N);

if p <= 0.5
    cls.tx_az(13:14,:) = [az_large_p;az_large_p];
    cls.tx_az(15:16,:) = [az_small_p;az_small_p];
    cls.tx_az(17:18,:) = [-az_large_n;-az_large_n];
else
    cls.tx_az(13:14,:) = [-az_large_n;-az_large_n];
    cls.tx_az(15:16,:) = [-az_small_n;-az_small_n];
    cls.tx_az(17:18,:) = [az_large_p;az_large_p];
end


% tx elevations
tx_el_1 = lr_el_1st(N);
cls.tx_el(1:2,:) = [tx_el_1; -tx_el_1];

cls.tx_el(3:5,:) = zeros(3,N);

cls.tx_el(6:10,:) = zeros(5,N);

tx_el_11 = lr_el_2nd(N);
cls.tx_el(11:12,:) = [tx_el_11;-tx_el_11];

tx_el_13 = lr_el_2nd_side_up1(N);
tx_el_15 = lr_el_2nd_side_up3(N);
tx_el_17 = lr_el_2nd_side_up2(N);

cls.tx_el(13:14,:) = [tx_el_13;-tx_el_13];
cls.tx_el(15:16,:) = [tx_el_15;-tx_el_15];
cls.tx_el(17:18,:) = [tx_el_17;-tx_el_17];


% rx azimuths
cls.rx_az(1:2,:) = zeros(2,N);

[az_small_p, az_large_p] = lr_az_1st_side_rx(N);
[az_small_n, az_large_n] = lr_az_1st_side_rx(N);

if p <= 0.5
    cls.rx_az(3:5,:) = [az_small_p;-az_large_n;-az_small_n];
else
    cls.rx_az(3:5,:) = [az_small_p;az_large_p;-az_small_n];
end

rx_az_12(find(tx_az_12<0)) = tx_az_12(find(tx_az_12<0)) + 180;
rx_az_12(find(tx_az_12>0)) = tx_az_12(find(tx_az_12>0)) - 180;

rx_az_14(find(tx_az_14<0)) = tx_az_14(find(tx_az_14<0)) + 180;
rx_az_14(find(tx_az_14>0)) = tx_az_14(find(tx_az_14>0)) - 180;

cls.rx_az(6:7,:) = [rx_az_12;rx_az_14];

cls.rx_az(8:10,:) = cls.tx_az(8:10,:);

cls.rx_az(11:12,:) = zeros(2,N);

if p <= 0.5
    cls.rx_az(13:14,:) = [-az_small_n;-az_small_n];
    cls.rx_az(15:16,:) = [-az_large_n;-az_large_n];
    cls.rx_az(17:18,:) = [az_small_p;az_small_p];
else
    cls.rx_az(13:14,:) = [az_small_p;az_small_p];
    cls.rx_az(15:16,:) = [az_large_p;az_large_p];
    cls.rx_az(17:18,:) = [-az_small_n;-az_small_n];
end

% rx elevations
cls.rx_el(1:2,:) = cls.tx_el(1:2,:);

cls.rx_el(3:5,:) = zeros(3,N);

cls.rx_el(6:10,:) = zeros(5,N);

cls.rx_el(11:12,:) = -cls.tx_el(11:12,:);

cls.rx_el(13:18,:) = cls.tx_el(13:18,:);