% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_toa_1st_up.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates times of arrival in [ns] for 1st order clusters obtained
%    from ceiling (or floor) reflections in LR environment
%
%    [y] = lr_toa_1st_up(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - times of arrival array
%
%  *************************************************************************************/
function [y] = lr_toa_1st_up(size)

u = rand(1,size);

x = [1,3,7];

a = [ 0.1667   -0.0833];
b = [-0.1667    0.5833];

c(1) = (b(1).^2 - (b(1)+x(1).*a(1)).^2)./(2.*a(1));

umax = ((a(1).*x(2)+b(1)).^2-(b(1).^2-2.*a(1).*c(1)))./(2.*a(1));

c(2) = ((b(2).^2+2.*a(2).*umax)-(x(2).*a(2)+b(2)).^2)./(2.*a(2));

index = find((u >= 0) & (u < umax));
y(index) = (-b(1) + sqrt(b(1).^2 - 2.*a(1).*(c(1)-u(index))))./a(1);
index = find((u >= umax) & (u <= 1));
y(index) = (-b(2) + sqrt(b(2).^2 - 2.*a(2).*(c(2)-u(index))))./a(2);