% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_toa_2nd_side_up.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates times of arrival in [ns] for 2nd order clusters obtained
%    from wall and ceiling reflections (wall and floor) in LR environment
%
%    [y] = lr_toa_2nd_side_up(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - times of arrival array
%
%  *************************************************************************************/
function [y] = lr_toa_2nd_side_up(size)

u = rand(1,size);

x = [2,10,25,38];

a = 2./89;
b = 4./89;
d = 1./89;

c(1) = -a.*x(1);
u1 = a.*x(2) + c(1);

c(2) = u1 - x(2).*b;
u2 = b.*x(3) + c(2);

c(3) = u2 - x(3).*d;

index = find((u >= 0) & (u < u1));
y(index) = (u(index) - c(1))./a;
index = find((u >= u1) & (u <= u2));
y(index) = (u(index) - c(2))./b;
index = find((u >= u2) & (u <= 1));
y(index) = (u(index) - c(3))./d;