% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Living Room Channel Model
%    File Name:     lr_toa_2nd_up_down.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
% 
%    function generates times of arrival in [ns] for 2nd order clusters obtained
%    from ceiling and floor reflections in LR environment
%
%    [y] = lr_toa_2nd_up_down(size)
%
%    Inputs:
%
%       1. size - target size of returned array
%
%    Outputs:
%
%       1. y - times of arrival array
%
%  *************************************************************************************/
function [y] = lr_toa_2nd_up_down(size)

y = 9.*rand(1,size) + 7;
