% /*************************************************************************************
%    Intel Corp.
%
%    Project Name:  60 GHz Enterprise Cubicle Channel Model
%    File Name:     cb_ch_model.m
%    Authors:       A. Lomayev, R. Maslennikov
%    Version:       5.0
%    History:       May 2010 created
%
%  *************************************************************************************
%    Description:
%
%    function returns channel impulse response for Enterprise Cubicle environment
%
%    [imp_res] = cb_ch_model()
%
%    Inputs:
%
%       no inputs, parameters are set in cb_ch_cfg.m configuration file
%
%    Outputs:
%
%       1. imp_res - channel impulse response
%
%  *************************************************************************************/
function [imp_res] = cb_ch_model()
clc

% load configuration structure <- cb_ch_cfg.m
cfg = cb_ch_cfg;

% generate space-time channel impulse response realization
ch = gen_cb_ch(cfg.cb,cfg.bf.ps,cfg.bf.pol);

% apply beamforming algorithm
[imp_res,toa] = beamforming(cfg.bf,ch);

% continuous time to descrete time conversion
imp_res = ct2dt(imp_res,toa,cfg.sample_rate);

% normalization according to Pnorm parameter
if (cfg.Pnorm)
    imp_res = imp_res./norm(imp_res);
end