% This source code is a part of Master Thesis titled
% "Resource Allocation in a Distributed Antenna System"
% at
%
% Institute for Digital Communications
% Friedrich-Alexander University Erlangen-Nürnberg (FAU)
% Wetterkreuz 15, D-91058 Erlangen, Germany
% Date: 9th January 2017
%
% Author: Meysam Goodarzi (meysam.goodarzi@fau.de)
% Second contact: Aravindh Krishnamoorthy (aravindh.krishnamoorthy@fau.de)
%

function [BandWidth,no_subcarriers,fftLength] = LTEmode(mode)
switch mode
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    case 1                % This mode does not exist in LTE, it's created by assuming carrier aggregration. 
        BandWidth=180e6;
        no_subcarriers= 12000;
        fftLength=20480;
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      
    case 2
        BandWidth=18e6;
        no_subcarriers= 1200;
        fftLength=2048;
    case 3
        BandWidth=13.5e6;
        no_subcarriers= 900;
        fftLength=1536;
    case 4
        BandWidth=9e6;
        no_subcarriers=600;
        fftLength=1024;
    case 5
        BandWidth=4.5e6;
        no_subcarriers= 300;
        fftLength=512;
    case 6
        BandWidth=2.7e6;
        no_subcarriers= 180;
        fftLength=256;
    case 7
        BandWidth=1.08e6;
        no_subcarriers= 72;
        fftLength=128;
    otherwise
        error('Unexpected Mode');
end
end
