% This source code is a part of Master Thesis titled
% "Resource Allocation in a Distributed Antenna System"
% at
%
% Institute for Digital Communications
% Friedrich-Alexander University Erlangen-Nürnberg (FAU)
% Wetterkreuz 15, D-91058 Erlangen, Germany
% Date: 9th January 2017
%
% Author: Meysam Goodarzi (meysam.goodarzi@fau.de)
% Second contact: Aravindh Krishnamoorthy (aravindh.krishnamoorthy@fau.de)
%

function hcoeff_mmWave = channel_Indoor_mmWave(IndoorScenario,no_subcarriers,fftLength,no_URUs,no_UE,RxTxDistance,mmw_Tx_antenna_gain_dB,LOS)

% fft length is normally larger than number of subcarriers. This part is
% required in order to extract desired number of subcarriers in the next
% parts.
fft_length = fftLength;
fr_temp = fft_length-no_subcarriers ;  


hcoeff_mmWave = [] ;

if IndoorScenario == 1             % if 'conference room' is chosen

    cfg.cr.ap_sp = 1 ;             % configuring the fixed TX scenario (on ceiling)

    for j = 1:no_UE
        h_temp = []
        for i=1:no_URUs
            cfg.cr.D = RxTxDistance(j,i);        % distance of each URU to UE
            cfg.cr.Plos = LOS(j,i) ;               % defining LOS scenario for each URU
            h0 = cr_ch_model();                  % generating the impulse response for conference-room
            h0f = fft(h0,fft_length);            % obtaining frequency impulse response
            h_temp(j,i,:) = [h0f(floor(fr_temp/2):floor(fr_temp/2)+no_subcarriers-1)];        % extracting the desired number of sub-carriers
            [  pathloss_dB(j,i) ] = path_loss_mmw( 'conference_room',cfg.cr.Plos,RxTxDistance(j,i),mmw_Tx_antenna_gain_dB);      % calculating pathloss for each UE-to-DUDAC link
        end
        % applying pathloss on channel impulse response
        MMW_pathloss_linear = 10.^(-pathloss_dB(j,:)./10).';
        MMW_pathloss_linear = repmat(MMW_pathloss_linear,1,no_subcarriers);
        hcoeff_mmWave(j,:,:) = (sqrt(MMW_pathloss_linear(:,:)).*squeeze(h_temp(j,:,:))) ;
    end


elseif IndoorScenario == 2          % if 'living room' is chosen


    for j = 1:no_UE
        h_temp = []
        for i=1:no_URUs
            cfg.lr.D = RxTxDistance(j,i);           % distance of each URU to UE
            cfg.cr.Plos = LOS(j,i) ;                  % defining LOS scenario for each URU
            h0 = lr_ch_model();                     % generating the impulse response for living-room
            h0f = fft(h0,fft_length);               % obtaining frequency impulse response
            h_temp(j,i,:) = [h0f(floor(fr_temp/2):floor(fr_temp/2)+no_subcarriers-1)];          % extracting the desired number of sub-carriers
            [  pathloss_dB(j,i) ] = path_loss_mmw( 'living_room',cfg.lr.Plos,RxTxDistance(j,i),mmw_Tx_antenna_gain_dB);        % calculating pathloss for each UE-to-DUDAC link
        end
        % applying pathloss on channel impulse response
        MMW_pathloss_linear = 10.^(-pathloss_dB./10).';
        MMW_pathloss_linear = repmat(MMW_pathloss_linear,1,no_subcarriers);
        hcoeff_mmWave(j,:,:) = (sqrt(MMW_pathloss_linear(:,:)).*squeeze(h_temp(j,:,:))) ;
    end

elseif IndoorScenario == 3          % if 'cubicle' is chosen


    for j = 1:no_UE
        h_temp = []
        for i=1:no_URUs
            cfg.cb.D = RxTxDistance(j,i);           % distance of each URU to UE
             cfg.cr.Plos = LOS(j,i) ;                 % defining LOS scenario for each URU
            h0 = cb_ch_model();                     % generating the impulse response for cubicle
            h0f = fft(h0,fft_length);               % obtaining frequency impulse response
            h_temp(j,i,:) = [h0f(floor(fr_temp/2):floor(fr_temp/2)+no_subcarriers-1)];          % extracting the desired number of sub-carriers
            [  pathloss_dB(j,i) ] = path_loss_mmw( 'cubicle',cfg.cb.Plos,RxTxDistance(j,i),mmw_Tx_antenna_gain_dB);       % calculating pathloss for each UE-to-DUDAC link
        end
        % applying pathloss on channel impulse response
        MMW_pathloss_linear = 10.^(-pathloss_dB./10).';
        MMW_pathloss_linear = repmat(MMW_pathloss_linear,1,no_subcarriers);
        hcoeff_mmWave(j,:,:) = (sqrt(MMW_pathloss_linear(:,:)).*squeeze(h_temp(j,:,:))) ;
    end
end

end

