% This source code is a part of Master Thesis titled
% "Resource Allocation in a Distributed Antenna System"
% at
%
% Institute for Digital Communications
% Friedrich-Alexander University Erlangen-Nürnberg (FAU)
% Wetterkreuz 15, D-91058 Erlangen, Germany
% Date: 9th January 2017
%
% Author: Meysam Goodarzi (meysam.goodarzi@fau.de)
% Second contact: Aravindh Krishnamoorthy (aravindh.krishnamoorthy@fau.de)
%
    function no_output = indoor_visualize (no_URUs,no_UE,room_side,RxTxDistance)

    
    gridd = ceil(sqrt(no_URUs));
    dist = room_side/(gridd -1);
    xGrid = repmat([-room_side/2:dist:room_side/2],1,gridd) ;
    yGrid = repmat([-room_side/2:dist:room_side/2],gridd,1) ;
    yGrid = reshape(yGrid,1,[]);
    
    RxPositionsX = xGrid(1:no_URUs)  ;
     RxPositionsY = yGrid(1:no_URUs);
    RxPositionsZ = [3*ones(1,no_URUs)] ;

    figure('units','normalized','outerposition',[0 0 1 1])

    % Plotting the URUs positions
    %--------------------------------
    for j=1:no_URUs;
        temp_txt = sprintf('URU %d',j);
        plot3([RxPositionsX(j) RxPositionsX(j)],[RxPositionsY(j) RxPositionsY(j)],[0 RxPositionsZ(j)],'--');
        text(RxPositionsX(j),RxPositionsY(j),RxPositionsZ(j),temp_txt);
        hold on
    end
    % defining axis range for X and Y axis
    axis([-5 5 -5 5 0 3]);
    plot3 (RxPositionsX,RxPositionsY,RxPositionsZ,'blacko'); grid on;
    hold on
    %---------------------------------
    
    % finding the right position of UE. Please note that a vector is
    % specified in SUDAS_Layout which describes the distance of each URU
    % to UE. of course the distance of each URU-to-UE link is dependent
    % on the other URU-to-UE links as well. Therefore, here, based on the
    % vector which has been entered as RxTxDistance, we try to find the
    % best point in space which satisfies the vector RxTxDistance.
    
    x0 = -3:0.1:3 ;
    y0 = -3:0.1:3 ;
    z0 = 0:0.1:2 ;
    for u = 1:no_UE
    loc = [];
    for i = 1:size(x0,2)
        for j = 1:size(y0,2)
            for k = 1:size(z0,2)
                tx0 = repmat(x0(i),1,8);
                ty0 = repmat(y0(j),1,8);
                tz0 = repmat(z0(k),1,8);
                dist = [sqrt((tx0-RxPositionsX).^2 + (ty0-RxPositionsY).^2 + (tz0-RxPositionsZ).^2)];
                loc(i,j,k) = sum(abs(RxTxDistance(u,:)-dist));
            end
        end
    end
    % finding the minimum error
    [M3 indx3] = min(loc, [], 3);
    [M2 indx2] = min(M3, [], 2);
    [M1 indx1] = min(M2, [], 1);
    a = indx1;
    indx2=indx2(indx1);
    b = indx2;
    indx3=indx3(indx1,indx2);
    c = indx3 ;
    % plotting the UE position
    plot3([x0(a) x0(a)],[y0(b) y0(b)],[0 z0(c)],'--');
    hold on
    plot3 (x0(a),y0(b),z0(c),'blacko'); grid on;
    temp_txt = sprintf('UE%d',u);
    text(x0(a),y0(b),z0(c),temp_txt);
    end
    title(sprintf('Visualizing of indoor environment, Number of URUs = %d, Number of UEs= %d, Room side= %d [meter]',no_URUs,no_UE,room_side));
    xlabel('X [meter]')
    ylabel('Y [meter]')
    zlabel('Z [meter]')
    no_output = [];

    end