% This source code is a part of Master Thesis titled
% "Resource Allocation in a Distributed Antenna System"
% at
%
% Institute for Digital Communications
% Friedrich-Alexander University Erlangen-Nürnberg (FAU)
% Wetterkreuz 15, D-91058 Erlangen, Germany
% Date: 9th January 2017
%
% Author: Meysam Goodarzi (meysam.goodarzi@fau.de)
% Second contact: Aravindh Krishnamoorthy (aravindh.krishnamoorthy@fau.de)


rate_tot = 0;

for ii = 1:no_it
    %% Generating O2I channel coefficients    
    NoTx = B ;                    % number of base stations (BSs)
    no_TxArrayElements = N ;      % number transmit antennas at BS
    no_URUs = M ;                     % number of URUs (which are considered
    % as receiver in outdoor-to-indoor scenario)
    
    % URUs' Positions (can be visualized using channel_O2I function)
    room_side = a ; % side of the square room [m]
    BS_to_S_dist = D ; % BS-to-S
    
    % The LTE mode in which the whole system works
    [BandWidth,no_subcarriers,fftLength] = LTEmode(lteMode);
    
    % Base station settings
    BS_antenna_model = 'ula8' ;         % it can be either 'ula8'(8 antenna
    % with 0 dB gain) or '3gpp' (18 dB
    % gain)
    % Please refer to Quadriga
    % documentation [page 30] in order
    % to use other types of antenna.
    % function channel_O2I needs to be
    % updated for other types of
    % anntennas.
    
    
    % the general scenario in which we are working. In order to change it
    % refer to Quadriga documentation, page 55.
    GeneralScenario = 'WINNER_UMa2Indoor_C4_NLOS' ;
    
    % Channel coefficients generation for all subcarriers
    H_C4Scenario = [];
    h_BS_S = channel_O2I( BandWidth,no_subcarriers,CenterFrequency,NoTx,BS_antenna_model,...
        no_TxArrayElements,no_URUs,room_side,BS_to_S_dist,GeneralScenario ) ;
    %  h_S_BS = h_BS_S' --> DL and UL are within same coherence time
    H_C4Scenario = h_BS_S;
    
    %% Generatin 60 GHz channel coeffcients    
    no_UE = K ;              % number of users in indoor environment
    RxTxDistance = randi([1 room_side],no_UE,no_URUs);   % distance of each URUs to
    % each UE (it can be a matrix
    % in case of multiple users)
    %RxTxDistance = [6 5 4 3 5 6 4 9;1 2 3 2 1 3 2 3];
    % mm-Wave transmitter antenna gain
    mmw_Tx_antenna_gain_dB = 0;
    
    % Line of Sight (LOS) or non-LOS for each URU-to-UE case
    LOS = ones(no_UE,no_URUs);
    
    % Visualizing indoor Layout
    %if ii==no_it
    %no_output = indoor_visualize (no_URUs,no_UE,room_side,RxTxDistance);
    %end
    
    % Channel coefficients generation for all subcarriers
    H_indoor = [];
    h_S_UE = channel_Indoor_mmWave(IndoorScenario,no_subcarriers,fftLength,...
        no_URUs,no_UE,RxTxDistance,mmw_Tx_antenna_gain_dB,LOS) ;
    % h_UE_S = h_S_UE' --> DL and UL happen within same coherence time
    H_indoor =  h_S_UE;
    %h_S_UE = squeeze(h_S_UE);
    
    %% Powers
    % max BS power (dBm)
    x = 19:3:46;
    % max of URUs power (13 dBm per MHz)
    pt_URU_max_DLorUL = 10.5 + 10*log10(BandWidth/1e+6) ;
    % max of UE power dBm (13 dBm per MHz)
    pt_UEk_max = 10*log10(BandWidth/1e+6) + 10.5 ;
    
    %% Optimization
    rate_joint = [];                % sum-rate for joint processing
    rate_ind = [];                % sum-rate for non-joint processing for approach developed in master thesis
    rate_cutset = [];              % sum-rate for non-joint proccesing for approach inspired by [1] in README file
    
    for hh= 1:length(x)
        pt_max = x(hh);
        
        
        % Joint processing Optimization
        
        [Y_P_BS_S_opt, Y_P_S_UE_opt, Y_P_UE_S_opt, Y_P_S_BS_opt, Y_s_DL, sumRate] = ...
            opt_joint(h_BS_S,h_S_UE,pt_max,pt_URU_max_DLorUL,no_subcarriers,no_URUs,no_UE,pt_UEk_max);
        rate_joint =   [rate_joint sumRate(1,1)] ;
        
        rate_cutset = [rate_cutset sumRate(2,1)] ;
        
        % Non-Joint processing Optimization
        
        [Y_P_BS_S_opt, Y_P_S_UE_opt, Y_P_UE_S_opt, Y_P_S_BS_opt, Y_s_DL, sumRate] = opt_ind(...
            h_BS_S,h_S_UE,pt_max, pt_URU_max_DLorUL, no_subcarriers,no_URUs, no_UE, pt_UEk_max);
        
        rate_ind = [rate_ind sumRate];
        
        
    end
    
    rate_tot = rate_tot + [rate_cutset;rate_joint;rate_ind]/10^6 ;
    
end

rate_tot = rate_tot/no_it ;

figure
plot(x,rate_tot,'-*');grid on

% plot
colours = {'b', 'r', 'black', 'b', 'o', 'g', 'r', 'b'} ;
marker = {'o', 's', 'd', 'v', '^', '<', '>', 'p', 'h', 'x', '+', '*'} ;
for i = 1:3
    p = plot(x,squeeze(rate_tot(i,:)),char(['-',colours{i},marker{i}])) ;
    hold on ;
end
ah = gca ;
s_pos =[42.5 300 47.5 350];
t_pos = [25 200 35 300];
zoomPlot(ah, s_pos, t_pos);

grid on;
legend('Cut-set Bound','AF Joint', 'AF Independent');
xlabel('BS transmit power (dBm)\rightarrow');
ylabel('Total throughput (Mbps)\rightarrow');
title(sprintf('Total throughput with SUDAS, %d x %d, BW=%d MHz (%d subcarriers)',N,M,BandWidth/10^6,no_subcarriers));



